package servercore.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.InvalidParameterException;

import servercore.tcp.TcpInstance;

public class TcpServer extends Thread{
	private static int port_num = 80;
	public boolean continuos = true;
	public boolean isRunning = false;

	public static void setPortNum(int num) throws InvalidParameterException {
		if(num > 65535 || num < 80) {
			throw new InvalidParameterException("IPアドレスは80～65535");
		}
		port_num = num;
	}
	public void run() {
		// 接続があるまで待機する
		ServerSocket serverSocket;
		try {
			serverSocket = new ServerSocket(port_num, 100);
			while(continuos) {

				Socket socket = null;
				try {
					socket = serverSocket.accept();
				} catch (IOException e) {
					e.printStackTrace();
					break;
				}
				TcpInstance ins = new TcpInstance(socket);
				ins.start();
			}
		} catch (IOException e1) {
			e1.printStackTrace();
		}
	}
}
